"""CLI entry point to execute scheduled email reminders."""

import argparse
from services.scheduler_service import SchedulerService


def parse_args() -> argparse.Namespace:
    parser = argparse.ArgumentParser(description="Scheduler Runner")
    parser.add_argument(
        "--send-now", action="store_true", help="Send reminders immediately"
    )
    return parser.parse_args()


def main() -> None:
    args = parse_args()
    scheduler = SchedulerService()
    if args.send_now:
        scheduler.send_now()
    else:
        scheduler.start()
        print("Scheduler started. Press Ctrl+C to stop.")
        try:
            import time
            while True:
                time.sleep(60)
        except KeyboardInterrupt:
            scheduler.scheduler.shutdown()


if __name__ == "__main__":
    main()
